import json
import os
import fire
import re

def convert_to_llava(data_file, output_file):
    anno = json.load(open(os.path.join(data_file), "r"))
    target_format = []
    for item_id, item in enumerate(anno["annotations"]):
        import random
        p = random.random()
        if p > 0.5:
          question = f"{item['question']}\n<image>"
        else:
          question = f"<image>\n{item['question']}"
        target_format.append({
            "id": item_id,
            "image": item['image_id']+".jpg",
            "conversations": [
                {'from': 'human', 'value': question},
                {'from': 'gpt', 'value': f"{item['answer']}"},
            ],
        })

    print(f'Number of samples: {len(target_format)}')

    with open(output_file, "w") as f:
        json.dump(target_format, f, indent=2)


def main(task, **kwargs):
    globals()[task](**kwargs)


if __name__ == "__main__":
    fire.Fire(main)
